
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Thu Feb 03 09:58:57 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief RSA external application ATP menu
   *
   *  \version CRYS_Ext_ATP_TST_RSA_main.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/* disabling pc lint warning regarding to constant condition :
   'Constant value Boolean' */
/*lint --e{506} */
/***** Include Files ******/
#include "CRYS.h"
#include "CRYS_Ext_ATP_TST_Defines.h"
#include "CRYS_ATP_TST_UTIL_Funcs.h"
#include "CRYS_Ext_ATP_RSA_Acceptance.h"
#include <stdio.h>

/******** Defines *****/
/******** Enums *****/
/******** Typedefs ****/
/******** Global Data ***/
/***** Private function prototype */
CRYSError_t CRYS_ExtApp_ATP_RSA_Acceptance_ALL_TESTS(int TST_KeyGeneration_TestStatus);

/******** Public Functions **/
void CRYS_ExtApp_ATP_RSA_main(void)
{
  DxUint8_t  Var;
  do
   {
	   do
	   {
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n\n\n--[ Ext SEP application RSA Acceptance tests Menu  ]----------------------------------"));
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [1] - Primitive Encrypt Decrypt                                      "));
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [2] - Primitive Sign Verify                                          "));
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n------ With Internal Key Generation ----------------------------------"));
	           
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [3] - PKCS#1v1.5 Encrypt Decrypt with internal KeyGen                "));
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [4] - PKCS#1v1.5 Non Integrated Sign Verify with internal KeyGen     "));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [5] - PKCS#1v1.5 Integrated Sign Verify with internal KeyGen         "));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [6] - PKCS#1v1.5 (HASHED) Sign Verify with internal KeyGen           "));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [7] - PKCS#1v2.1 OAEP Encrypt Decrypt with internal KeyGen           "));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [8] - PKCS#1v2.1 PSS Non Integrated Sign Verify with internal KeyGen "));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [9] - PKCS#1v2.1 PSS Integrated Sign Verify with internal KeyGen     "));
               
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [A] - PKCS#1v2.1 PSS (HASHED) Sign Verify with internal KeyGen       "));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [B] - Get Private & Public Key  with internal KeyGen			        "));
                 
			   ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n------ Without Internal Key Generation -------------------------------"));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [C] - PKCS#1v1.5 Encrypt Decrypt w/o KeyGen                          "));
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [D] - PKCS#1v1.5 Non Integrated Sign Verify w/o internal KeyGen      "));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [E] - PKCS#1v1.5 Integrated Sign Verify w/o internal KeyGen          "));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [F] - PKCS#1v1.5 (HASHED) Sign Verify w/o internal KeyGen            "));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [G] - PKCS#1v2.1 OAEP Encrypt Decrypt w/o internal KeyGen            "));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [H] - PKCS#1v2.1 PSS Non Integrated Sign Verify w/o internal KeyGen  "));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [I] - PKCS#1v2.1 PSS Integrated Sign Verify w/o internal KeyGen      "));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [J] - PKCS#1v2.1 PSS (HASHED) Sign Verify w/o internal KeyGen        "));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [K] - Get Private & Public Key  w/o internal KeyGen	     	        "));
			   
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n----------------------------------------------------------------------"));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [T] - ALL Ext SEP application RSA Acceptance Tests with internal KeyGen                  "));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [S] - ALL Ext SEP application RSA Acceptance Tests w/o internal KeyGen                   "));
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [Z] - End of tests return to prev menu                               "));
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n----------------------------------------------------------------------\n\n"));

	           scanf("\n%c",&Var);
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n Test = %c\n",Var));
	           if (Var<='Z')
	                    break;
	           else
	           {
	                 ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n Error[%d]  Please select '1'-'XX'\n\n",Var));
	           }

	    }while(1);


	    switch(Var)
	    {
		  	case '1':
				    CRYS_Ext_ATP_RSA_PRIME_EncDec();
				    break;
				    
			case '2':
			        CRYS_Ext_ATP_RSA_PRIME_SignVerify();
				    break;
		  	
			case '3':
				    CRYS_Ext_ATP_RSA_PKCS1v15_EncDec(TST_INTERNAL_KG);
				    break;
		   	case '4':
				    CRYS_Ext_ATP_RSA_PKCS1v15_NonIntegrate_SignVerify(TST_INTERNAL_KG);
				    break;
		   	case '5':
				    CRYS_Ext_ATP_RSA_PKCS1v15_Integrated_SignVerify(TST_INTERNAL_KG);
				    break;
			case '6':
				    CRYS_Ext_ATP_RSA_PKCS1v15_ExternalHash_SignVerify(TST_INTERNAL_KG);
				    break;
		   	
		  	case '7':
				    CRYS_Ext_ATP_RSA_OAEP_EncDec (TST_INTERNAL_KG);
				    break;
		  	case '8':
				    CRYS_Ext_ATP_RSA_PSS_NonIntegrate_SignVerify (TST_INTERNAL_KG);
				    break;
		  	case '9':
				    CRYS_Ext_ATP_RSA_PSS_Integrated_SignVerify (TST_INTERNAL_KG);
		    	    break;
			case 'A':
				    CRYS_Ext_ATP_RSA_PSS_ExternalHash_SignVerify(TST_INTERNAL_KG);
				    break;
		   	case 'B':
				    CRYS_Ext_ATP_RSA_Get_PrivAndPubKey(TST_INTERNAL_KG);
				    break;
		  	
			case 'C':
				    CRYS_Ext_ATP_RSA_PKCS1v15_EncDec(TST_NO_INTERNAL_KEYGEN);
				    break;
		   	case 'D':
				    CRYS_Ext_ATP_RSA_PKCS1v15_NonIntegrate_SignVerify(TST_NO_INTERNAL_KEYGEN);
				    break;
		   	case 'E':
				    CRYS_Ext_ATP_RSA_PKCS1v15_Integrated_SignVerify(TST_NO_INTERNAL_KEYGEN);
				    break;
		   	case 'F':
				    CRYS_Ext_ATP_RSA_PKCS1v15_ExternalHash_SignVerify(TST_NO_INTERNAL_KEYGEN);
				    break;
		  	case 'G':
				    CRYS_Ext_ATP_RSA_OAEP_EncDec (TST_NO_INTERNAL_KEYGEN);
				    break;
		  	case 'H':
				    CRYS_Ext_ATP_RSA_PSS_NonIntegrate_SignVerify (TST_NO_INTERNAL_KEYGEN);
				    break;
		  	case 'I':
				    CRYS_Ext_ATP_RSA_PSS_Integrated_SignVerify (TST_NO_INTERNAL_KEYGEN);
				    break;
			case 'J':
				    CRYS_Ext_ATP_RSA_PSS_ExternalHash_SignVerify (TST_NO_INTERNAL_KEYGEN);
				    break;
		   	case 'K':
				    CRYS_Ext_ATP_RSA_Get_PrivAndPubKey (TST_NO_INTERNAL_KEYGEN);
				    break;
			
		  	case 'T':
				    CRYS_ExtApp_ATP_RSA_Acceptance_ALL_TESTS (TST_INTERNAL_KG);
				    break;
		  	case 'S':
				    CRYS_ExtApp_ATP_RSA_Acceptance_ALL_TESTS (TST_NO_INTERNAL_KEYGEN);
				    break;
	       	case 'Z':
	                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n End of Acceptance RSA tests \n"));
	                break ;

	       	default:
	              ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n* Error in test selection [%c]\n",Var));
	    }
	       if(Var =='Z')
	       break;
     }while (1);
}

/*** run all Acceptance tests ********/
/*****************/

CRYSError_t CRYS_ExtApp_ATP_RSA_Acceptance_ALL_TESTS(int TST_KeyGeneration_TestStatus)
{
    CRYSError_t TST_ATP_RSA_Error = TESTPASS;

    TST_ATP_Error = CRYS_Ext_ATP_RSA_PRIME_EncDec();
    TST_ATP_RSA_Error = TST_ATP_RSA_Error+TST_ATP_Error;

    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
	    if (TST_ATP_RSA_Error != TESTPASS)
			    return 	TST_ATP_RSA_Error;
    #endif

    TST_ATP_Error = CRYS_Ext_ATP_RSA_PRIME_SignVerify();
    TST_ATP_RSA_Error = TST_ATP_RSA_Error+TST_ATP_Error;

    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
	    if (TST_ATP_RSA_Error != TESTPASS)
			    return 	TST_ATP_RSA_Error;
    #endif
    
    TST_ATP_Error = CRYS_Ext_ATP_RSA_PKCS1v15_EncDec(TST_KeyGeneration_TestStatus);
    TST_ATP_RSA_Error = TST_ATP_RSA_Error+TST_ATP_Error;

    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
	    if (TST_ATP_RSA_Error != TESTPASS)
			    return 	TST_ATP_RSA_Error;
    #endif

    TST_ATP_Error = CRYS_Ext_ATP_RSA_PKCS1v15_NonIntegrate_SignVerify(TST_KeyGeneration_TestStatus);
    TST_ATP_RSA_Error = TST_ATP_RSA_Error+TST_ATP_Error;

    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
	    if (TST_ATP_RSA_Error != TESTPASS)
			    return 	TST_ATP_RSA_Error;
    #endif

    TST_ATP_Error = CRYS_Ext_ATP_RSA_PKCS1v15_Integrated_SignVerify(TST_KeyGeneration_TestStatus);
    TST_ATP_RSA_Error = TST_ATP_RSA_Error+TST_ATP_Error;

    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
	    if (TST_ATP_RSA_Error != TESTPASS)
			    return 	TST_ATP_RSA_Error;
    #endif

    TST_ATP_Error = CRYS_Ext_ATP_RSA_PKCS1v15_ExternalHash_SignVerify(TST_KeyGeneration_TestStatus);
    TST_ATP_RSA_Error = TST_ATP_RSA_Error+TST_ATP_Error;

    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
	    if (TST_ATP_RSA_Error != TESTPASS)
			    return 	TST_ATP_RSA_Error;
    #endif
    
    TST_ATP_Error = CRYS_Ext_ATP_RSA_OAEP_EncDec(TST_KeyGeneration_TestStatus);
    TST_ATP_RSA_Error = TST_ATP_RSA_Error+TST_ATP_Error;

    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
	    if (TST_ATP_RSA_Error != TESTPASS)
			    return 	TST_ATP_RSA_Error;
    #endif

    TST_ATP_Error = CRYS_Ext_ATP_RSA_PSS_NonIntegrate_SignVerify(TST_KeyGeneration_TestStatus);
    TST_ATP_RSA_Error = TST_ATP_RSA_Error+TST_ATP_Error;

    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
	    if (TST_ATP_RSA_Error != TESTPASS)
			    return 	TST_ATP_RSA_Error;
    #endif

    TST_ATP_Error = CRYS_Ext_ATP_RSA_PSS_Integrated_SignVerify(TST_KeyGeneration_TestStatus);
    TST_ATP_RSA_Error = TST_ATP_RSA_Error+TST_ATP_Error;

    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
	    if (TST_ATP_RSA_Error != TESTPASS)
			    return 	TST_ATP_RSA_Error;
    #endif

    TST_ATP_Error = CRYS_Ext_ATP_RSA_PSS_ExternalHash_SignVerify(TST_KeyGeneration_TestStatus);
    TST_ATP_RSA_Error = TST_ATP_RSA_Error+TST_ATP_Error;

    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
	    if (TST_ATP_RSA_Error != TESTPASS)
			    return 	TST_ATP_RSA_Error;
    #endif
    
    TST_ATP_Error = CRYS_Ext_ATP_RSA_Get_PrivAndPubKey(TST_KeyGeneration_TestStatus);
    TST_ATP_RSA_Error = TST_ATP_RSA_Error+TST_ATP_Error;

    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
	    if (TST_ATP_RSA_Error != TESTPASS)
			    return 	TST_ATP_RSA_Error;
    #endif
 
	/*Check if all tests pass*/
	if (TST_ATP_RSA_Error != TESTPASS)
        {
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!!!!!!! ONE OR MORE OF THE RSA TESTS FAILED  !!!!!!!!!!!!!!!!!!!!\n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
        }
        else
        {
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n \n**********************\n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*** ALL OF THE RSA Acceptance TESTS PASS   :-)     ***\n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
            if (TST_KeyGeneration_TestStatus  == TST_EXTERNAL_KEYPAIR)
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!!!!!!!!!!!!!! WITHOUT INTERNAL KEY GENERATION !!!!!!!!!!!!!!!!!\n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
		}
		return TST_ATP_RSA_Error;
}



